require 'rails_helper'

module History
  describe ImpersonateUserAudit do
    let(:creator_id) {'someotherID'}
    let(:user_id) {'someID'}
    let(:ip_addr) {'192.168.1.1'}
    let(:ticket_id) {'my-ticket-id'}
    let(:reason) {'my-reason'}

    describe '#add' do
      before(:each) do
        expect(History::AddAudit).to receive(:add)
          .with({
            :action => 'impersonate_user',
            :user_type => 'ldap_user',
            :user_id => 'someotherID',
            :resource_type => 'twitch_user',
            :resource_id => 'someID',
            :changes => [
              History::ChangeSet.new(attribute: 'ip_address', new_value: ip_addr),
              History::ChangeSet.new(attribute: 'ticket_id', new_value: ticket_id)
            ],
            :description => reason
          })
          .once

        ImpersonateUserAudit.new(
          admin_id: creator_id,
          user_id: user_id,
          ip_address: ip_addr,
          ticket_id: ticket_id,
          reason: reason
        ).add
      end

      context 'with all parameters provided' do
        it 'adds an audit with all fields' do
        end
      end
    end
  end
end
