require 'rails_helper'

module History
  describe SessionAudit do
    let(:creator_id) {'someotherID'}
    let(:user_id) {'someID'}
    let(:ip_addr) {'192.168.1.1'}

    describe '#add' do
      it 'adds a new History::Audit object to the audit trail' do
        allow(History::AddAudit).to receive(:add)

        SessionAudit.new(admin_id: creator_id, user_id: user_id, ip_address: ip_addr).add
        expect(History::AddAudit).to have_received(:add).with(
            {
              :action => 'session_created',
              :user_type => 'ldap_user',
              :user_id => 'someotherID',
              :resource_type => 'twitch_user',
              :resource_id => 'someID',
              :description => 'IP address 192.168.1.1'
            }
        )
      end
    end
  end
end
