require 'rails_helper'

module Keys
  describe HandlerGroup do
    let(:cursor) {'test-cursor'}
    let(:ldap) {'test-ldap'}
    let(:handler_group_id) {'test-handler-group-id'}
    let(:description) {'description'}

    describe "all" do
      it "should call phanto GetKeyHandlerGroups" do
        expect(Base).to receive(:post).with(
          '/twirp/code.justin.tv.commerce.phanto.Phanto/GetKeyHandlerGroups',
          headers: Keys.ldap_header(ldap),
          body: { 'cursor' => cursor }.to_json
        ).and_return(double(success?: true))
        resp = HandlerGroup.all(cursor, ldap)
        expect(resp.success?).to eq true
      end
    end

    describe "get" do
      it "should call phanto GetKeyHandlerGroup" do
        expect(Base).to receive(:post).with(
          '/twirp/code.justin.tv.commerce.phanto.Phanto/GetKeyHandlerGroup',
          headers: Keys.ldap_header(ldap),
          body: { 'handler_group_id' => handler_group_id }.to_json
        ).and_return(double(success?: true))
        resp = HandlerGroup.get(handler_group_id, ldap)
        expect(resp.success?).to eq true
      end
    end

    describe "create" do
      it "should call phanto UpdateKeyHandlerGroup" do
        expect(Base).to receive(:post).with(
          '/twirp/code.justin.tv.commerce.phanto.Phanto/UpdateKeyHandlerGroup',
          headers: Keys.ldap_header(ldap),
          body: {
            'handler_group_id' => handler_group_id,
            'description' => description,
            'authorized_tuids' => [],
            'authorized_client_ids' => []
          }.to_json
        ).and_return(double(success?: true))
        hg = HandlerGroup.new
        hg.handler_group_id = handler_group_id
        hg.description = description
        hg.authorized_tuids = []
        hg.authorized_client_ids = []
        hg.ldap_login = ldap
        resp = hg.create
        expect(resp.success?).to eq true
      end
    end

  end
end