require 'rails_helper'

module Mako
  describe EmotePrefix do
    include ServiceHelper

    let(:channel_id) { "12345" }
    let(:prefix) { "myprefix" }
    let(:state) { "PREFIX_PENDING" }

    describe 'get_pending_prefixes' do
      let(:limit) { 20 }
      let(:entry) do
        {
          "channel_id" => channel_id,
          "prefix" => prefix,
          "state" => state
        }
      end
      let(:prefix_data) { double(prefix_entries: [entry]) }

      let(:get_prefixes_by_state_response) do
        double(error: error, data: prefix_data)
      end

      let(:params) do
        {
          state: state,
          limit: limit
        }
      end
      subject { EmotePrefix.get_pending_prefixes(limit) }

      context 'with successful mako response' do
        let(:error) { nil }

        it 'should call client get_prefixes_by_state and returns prefix_data object' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_prefixes_by_state).with(params).and_return(get_prefixes_by_state_response)
          expect(subject[0]).to have_attributes(
            :channel_id => channel_id,
            :prefix => prefix,
            :state => state
          )
        end
      end

      context 'with error mako response' do
        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_prefixes_by_state).with(params).and_return(get_prefixes_by_state_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end

    describe 'get_prefix' do
      let(:prefix_data) do
        {
          "prefix" => prefix,
          "state" => state
        }
      end

      let(:get_prefix_response) do
        double(
          error: error,
          data: prefix_data
        )
      end

      subject { EmotePrefix.get_prefix(channel_id) }

      context 'with successful mako response' do
        let(:error) { nil }

        it 'should call client get_prefix and returns prefix_data object' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_prefix).with({:channel_id => channel_id}).and_return(get_prefix_response)
          expect(subject).to have_attributes(
            :prefix => prefix,
            :state => state
          )
        end
      end

      context 'with error mako response' do

        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_prefix).with({:channel_id => channel_id}).and_return(get_prefix_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end

    describe 'set_prefix' do
      let(:set_prefix_response) do
        double(
          error: error,
          data: {}
        )
      end

      let(:params) do
        {
          channel_id: channel_id,
          prefix: prefix,
          state: state
        }
      end

      subject { EmotePrefix.set_prefix(channel_id, prefix, state) }

      context 'with error mako response' do

        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:set_prefix).with(params).and_return(set_prefix_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end
  end
end
