require 'rails_helper'

module Mako
  describe Emote do
    include ServiceHelper

    let(:emote_id) { "12345" }

    describe 'get_emoticons_by_emoticon_ids' do

      let(:emote) do
        {
          "id" => emote_id,
        }
      end
      let(:emoticons_data) { double(emoticons: [emote]) }

      let(:get_emoticons_by_emoticon_ids_response) do
        double(error: error, data: emoticons_data)
      end

      let(:params) do
        {
          emoticon_ids: [emote_id]
        }
      end

      subject { Emote.get_emoticons_by_emoticon_ids([emote_id]) }

      context 'with successful mako response' do
        let(:error) { nil }

        it 'should call client get_emoticons_by_emoticon_ids and returns emote object' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_emoticons_by_emoticon_ids).with(params).and_return(get_emoticons_by_emoticon_ids_response)
          expect(subject[0]).to have_attributes(
            :id => emote_id
          )
        end
      end

      context 'with error mako response' do
        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_emoticons_by_emoticon_ids).with(params).and_return(get_emoticons_by_emoticon_ids_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end

    describe 'get_emoticons_by_group' do
      let(:group_id) { "56789" }

      let(:emote) do
        {
          "group_id" => group_id,
        }
      end
      let(:emoticons_data) { double(emoticons: [emote]) }

      let(:groups_data) { double(groups: [emoticons_data]) }

      let(:get_emoticons_by_groups_response) do
        double(error: error, data: groups_data)
      end

      let(:params) do
        {
          emoticon_group_keys: [group_id]
        }
      end

      subject { Emote.get_emoticons_by_group(group_id)}

      context 'with successful mako response' do
        let(:error) { nil }

        it 'should call client get_emoticons_by_emoticon_ids and returns emote object' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_emoticons_by_groups).with(params).and_return(get_emoticons_by_groups_response)
          expect(subject[0]).to have_attributes(
            :group_id => group_id
          )
        end
      end

      context 'with error mako response' do
        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:get_emoticons_by_groups).with(params).and_return(get_emoticons_by_groups_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end

    describe 'deactivate_emoticon' do
      let(:deactivate_emoticon_response) do
        double(
          error: error,
          data: {}
        )
      end

      let(:params) do
        {
          id: emote_id
        }
      end

      subject { Emote.deactivate_emoticon(emote_id) }

      context 'with error mako response' do

        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:deactivate_emoticon).with(params).and_return(deactivate_emoticon_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end

    describe 'update_emote_code_suffix' do
      let(:code_suffix) { "newsuffix" }
      let(:update_emote_code_suffix_response) do
        double(
          error: error,
          data: {}
        )
      end

      let(:params) do
        {
          id: emote_id,
          code_suffix: code_suffix
        }
      end

      subject { Emote.update_emote_code_suffix(emote_id, code_suffix) }

      context 'with error mako response' do

        let(:error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:update_emote_code_suffix).with(params).and_return(update_emote_code_suffix_response)
          expect {subject}.to raise_error(error.msg)
        end
      end
    end
  end
end
