require 'rails_helper'

module Mako
  describe EmoteUploader do
    include ServiceHelper

    let(:user_id) { "0" }
    let(:image_id) { "123" }
    let(:image_url) { "imageurl" }
    let(:upload_id) { "456" }
    let(:upload_url) { "uploadurl" }
    let(:test_path) { "test_path" }
    let(:emote_id) { "345689" }
    let(:uploader_user_name) { "anuploader" }
    let(:uploader_email) { "anuploader@twitch.tv" }

    describe 'upload' do

      let(:config_data) do
        Code::Justin::Tv::Commerce::Mako::Dashboard::GetEmoteUploadConfigResponse.new(
          upload_configs: [
            Code::Justin::Tv::Commerce::Mako::Dashboard::EmoteUploadConfig.new(
              id: upload_id,
              url: upload_url,
              images: [
                Code::Justin::Tv::Commerce::Mako::Dashboard::EmoteImage.new(
                  id: image_id,
                  url: image_url
                )
              ]
            ),
            Code::Justin::Tv::Commerce::Mako::Dashboard::EmoteUploadConfig.new(
              id: upload_id,
              url: upload_url,
              images: [
                Code::Justin::Tv::Commerce::Mako::Dashboard::EmoteImage.new(
                  id: image_id,
                  url: image_url
                )
              ]
            ),
            Code::Justin::Tv::Commerce::Mako::Dashboard::EmoteUploadConfig.new(
              id: upload_id,
              url: upload_url,
              images: [
                Code::Justin::Tv::Commerce::Mako::Dashboard::EmoteImage.new(
                  id: image_id,
                  url: image_url
                )
              ]
            )
          ]
        )
      end

      let(:config_response) do
        double(error: config_error, data: config_data)
      end

      let(:upload_response) do
        double(success?: true, status: 200, body: "somedata")
      end

      let(:create_emoticon_response) do
        double(error: create_error, data: { 'id' => emote_id })
      end

      let(:tempfile) do
        double(path: test_path)
      end

      let(:image_data) do
        double(tempfile: tempfile)
      end

      let(:options) do
        {
          code_prefix: "prefix",
          code_suffix: "suffix",
          group_id: "123",
          data28: image_data,
          data56: image_data,
          data112: image_data,
          user_id: user_id,
          uploader_user_name: uploader_user_name,
          uploader_email: uploader_email,
        }
      end

      let(:publish_notification_response) do
        double(
          error: nil,
          data: {}
        )
      end

      subject { EmoteUploader.upload(options) }

      context 'with successful mako response' do
        let(:config_error) { nil }
        let(:create_error) { nil }

        it 'should call client get_emote_upload_config and returns config_data object' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::Dashboard::MakoClient).to receive(:get_emote_upload_config).at_least(:once).and_return(config_response)
          allow(File).to receive(:binread).with(test_path).and_return(user_id)
          allow_any_instance_of(Faraday::Connection).to receive(:put).and_return(upload_response)
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:create_emoticon).and_return(create_emoticon_response)
          allow_any_instance_of(::Receiver::ReceiverClient).to receive(:publish_notification).and_return(publish_notification_response)
          expect(subject).to eq(emote_id)
        end
      end

      context 'with error from mako get_emote_upload_config response' do
        let(:config_error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::Dashboard::MakoClient).to receive(:get_emote_upload_config).at_least(:once).and_return(config_response)
          expect {subject}.to raise_error(config_error.msg)
        end
      end

      context 'with error from mako create_emoticon response' do
        let(:config_error) { nil }
        let(:create_error) { double(msg: 'failed something') }

        it 'should raise error' do
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::Dashboard::MakoClient).to receive(:get_emote_upload_config).at_least(:once).and_return(config_response)
          allow(File).to receive(:binread).with(test_path).and_return(user_id)
          allow_any_instance_of(Faraday::Connection).to receive(:put).and_return(upload_response)
          expect_any_instance_of(::Code::Justin::Tv::Commerce::Mako::MakoClient).to receive(:create_emoticon).and_return(create_emoticon_response)
          expect {subject}.to raise_error(create_error.msg)
        end
      end
    end
  end
end