module Passport
  describe UserImpersonation do
    let(:user_id) { 'my-user-id' }
    let(:admin_id) { 'my-admin-id' }
    let(:user_ip) { 'my-admin-id' }

    let(:passport_token) { 'my-passport-token' }
    let(:service_endpoint) { 'https://my-passport-host' }
    let(:redirect_endpoint) { Settings.passport.redirect_endpoint }
    let(:user_impersonation) do
      described_class.new(
        user_id: user_id,
        admin_id: admin_id,
        user_ip: user_ip
      )
    end

    before(:each) do
      allow(Base).to receive(:service_endpoint)
        .and_return(service_endpoint)
      allow(Base).to receive(:passport_token)
        .with(user_id)
        .and_return(passport_token)
    end

    describe 'url' do
      it 'builds a url' do
        expect(user_impersonation.url)
          .to eq("#{redirect_endpoint}/api/v1/impersonation/#{user_id}?token=#{passport_token}")
      end
    end
  end
end
