require 'rails_helper'

RSpec.describe Payments::EmailPurchaseOrdersReport, type: :service do
  describe "#email_purchase_orders_report" do
    let(:params) { {} }
    let(:response) do
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(true)
      end
    end

    subject {Payments::EmailPurchaseOrdersReport.do(params)}

    describe 'with empty params' do
      before do
        allow(Payments::EmailPurchaseOrdersReport).to receive(:post).with('/admin/email_purchase_orders/', body: params).and_return(response)
      end

      it 'response is true' do
        expect(subject).to eq(true)
      end
    end
  end
end
