require 'rails_helper'

module Payments
  describe PurchaseProfile do
    let(:id) { 1 }
    let(:ticket_id) { 1337 }
    let(:owner_id) { 1234 }
    let(:ticket) { double(id: ticket_id, owner_id: owner_id) }

    let(:purchase_profile) { PurchaseProfile.new(id: id, ticket_id: ticket_id) }

    describe "ticket" do
      subject { purchase_profile.ticket }

      it "should call Subscription.get_by_purchase_profile to retrieve ticket" do
        expect(::Substwirp::Subscription).to receive(:get_by_purchase_profile).with(id).and_return(ticket)
        subject
      end
    end

    describe "ticket_owner" do
      subject { purchase_profile.ticket_owner }

      it "should search for user via ticket owner id" do
        expect(::Substwirp::Subscription).to receive(:get_by_purchase_profile).with(id).and_return(ticket)
        expect(::Twitch::User).to receive(:find).with(owner_id).and_return(nil)
        subject
      end
    end

    describe "#product" do
      subject { purchase_profile.product }

      describe "when ticket product not found" do
        let(:ticket_product_id) { 5432 }
        let(:ticket) { Ticket.from_attributes({id: ticket_id, ticket_product_id: ticket_product_id}) }
        before do
          allow(Substwirp::Subscription).to receive(:get_by_purchase_profile).with(id).and_return(ticket)
          allow(Subscriptions::TicketProduct).to receive(:find).with(ticket_product_id).and_return(Subscriptions::TicketProduct.from_errors("some error"))
        end

        it "should have nil product" do
          expect(subject).to be_nil
        end
      end
    end
  end
end
