require 'rails_helper'

module PayoutEntities
  describe Base do
    describe 'ldap_header' do
      let(:ldap_login) { 'my-ldap-login' }
      it 'returns a map' do
        expect(described_class.ldap_headers(ldap_login: ldap_login)).to eq({
          'Twitch-LDAP-Login' => ldap_login,
        })
      end
    end
  end

  describe 'PayoutEntities.payout_type' do
    let(:channel_id) { "1337" }

    before(:each) do
      Ripley::BatchGetPayoutType.stub(:call).and_return({channel_id => "MY COOL PAYOUT TYPE"})
    end

    subject do
      PayoutEntity.payout_type(channel_id)
    end

    it 'should call Ripley::BatchGetPayoutType.call with array including channel_id' do
      expect(Ripley::BatchGetPayoutType).to receive(:call).with([channel_id])
      subject
    end
  end
end
