require 'rails_helper'

module PayoutEntities
  describe PayoutEntity do

    describe '.find' do
      let(:ldap_login) { 'test' }

      before do
        allow(described_class).to receive(:ldap_headers).and_return({
            'Twitch-LDAP-Login' => ldap_login,
          })
      end

      it 'does not throw an error if the response is nil' do
        env = Faraday::Env.from(status: 200, body: 'yikes',
                                response_headers: { 'Content-Type' => 'text/plain' })
        mock_response = Faraday::Response.new(env)

        expect(PayoutEntities::PayoutEntity).to receive(:get).with("/payout/1/payout_entities", {:headers => {"Twitch-LDAP-Login" => 'test'}}).and_return(mock_response)

        expect do
          PayoutEntities::PayoutEntity.find('1', options: {}, find_by_channel_id: true)
        end.to_not raise_error(NoMethodError)
      end
    end

  end
end
