require 'rails_helper'

module PayoutEntities
  describe Workflow do
    describe 'restart' do
      subject { Workflow.restart(channel_id, options) }

      let(:channel_id) { '123' }
      let(:options) do
        {
          ldap_login: 'ldap_login'
        }
      end

      it 'should send the request' do
        expect(Base).to receive(:delete).with(
          '/payout/123/workflow',
          headers: Base.ldap_headers(options)
        ).and_return(double(success?: true))

        expect(subject).to eq true
      end
    end
  end
end
