require 'rails_helper'

module PlatformConnections
  describe Connection do
    let(:user_id) {'someID'}

    describe '#get_all' do
      it 'returns all connected platforms for a user' do
        allow(Connections::Connection).to receive(:get_all).and_return({'blizzard' => false, 'league' => false})

        result = Connection.get_all(user_id)
        expect(result).to eq({ 'blizzard' => false, 'league' => false})
      end
    end

    describe '#destroy' do
      it 'destroys Connection service connections when the platform is in the Connections service' do
        allow(Connections::Connection).to receive(:destroy)

        Connection.destroy('some-user-id', 'facebook')
        expect(Connections::Connection).to have_received(:destroy).with('some-user-id', 'facebook')
      end

      it 'does nothing when the platform is not recognized' do
        allow(Connections::Connection).to receive(:destroy)

        Connection.destroy('some-user-id', 'unknown-platform')
        expect(Connections::Connection).not_to have_received(:destroy)
      end

    end
  end
end
