require 'rails_helper'

RSpec.describe RevenueReporting::PayoutDetail do
  describe '#all_prime' do
    subject { RevenueReporting::PayoutDetail.all_prime(channel_id) }
    let(:channel_id) { '144364159' }

    describe 'with no params' do
      let(:channel_id) { nil }

      it 'returns []' do
        expect(subject).to eq([])
      end
    end

    describe 'with valid params' do
      let(:response) { double(:response, success?: true, body: body) }
      let(:body) { { 'prime_payout_history' => payout_history } }
      let(:payout_history) { [] }

      before do
        allow(RevenueReporting::PayoutDetail).to receive(:get).with("/internal/dashboard/prime_payout_details?channel_id=#{channel_id}").and_return(response)
        allow(RevenueReporting::PayoutDetail).to receive(:from_attributes).and_return(RevenueReporting::PayoutDetail.new)
      end

      describe 'with matching purchase orders' do
        let(:payout_history) { [{ currency: :USD, month: 1, year: 2019 }, { currency: :USD, month: 1, year: 2019 }] }
        it 'should return the results' do
          expect(subject).to satisfy('right number of payout details') { |subj| subj.count == payout_history.count }
        end

        it 'should return RevenueReporting PayoutDetail' do
          expect(subject).to satisfy('payout detail objects') { |subj| subj.all? { |pd| pd.class == RevenueReporting::PayoutDetail } }
        end
      end

      describe 'with RRW service call failure' do
        let(:response) { double(:response, success?: false) }
        it 'should return nil' do
          expect(subject).to eq(nil)
        end
      end
    end
  end
end
