require 'rails_helper'

RSpec.describe Ripley::ValidatedNonPartner do
  include ServiceHelper

  describe "#find" do
    let(:twirp_response) do
      data = Code::Justin::Tv::Revenue::Ripley::GetValidatedNonPartnerResponse.new
      data.is_validated_non_partner = true
      Twirp::ClientResp.new(data, nil)
    end

    before(:each) do
      expect(described_class.twirp_client).to(receive(:get_validated_non_partner_status)).and_return(twirp_response)
    end

    it 'retrieves validated non partner response' do
      is_validated_non_partner = described_class.find("some channel id")
      expect(is_validated_non_partner).to eq(twirp_response.data.is_validated_non_partner)
    end
  end

  describe "#delete" do
    let(:twirp_response) do
      data = Code::Justin::Tv::Revenue::Ripley::EditValidatedNonPartnerResponse.new
      Twirp::ClientResp.new(data, nil)
    end

    before(:each) do
      expect(described_class.twirp_client).to(receive(:delete_validated_non_partner_status)).and_return(twirp_response)
    end

    it 'deletes validated non partner' do
      resp = described_class.delete("some channel id")
      expect(resp).to eq(twirp_response)
    end
  end

  describe "#add" do
    let(:twirp_response) do
      data = Code::Justin::Tv::Revenue::Ripley::EditValidatedNonPartnerResponse.new
      Twirp::ClientResp.new(data, nil)
    end

    before(:each) do
      expect(described_class.twirp_client).to(receive(:add_validated_non_partner_status)).and_return(twirp_response)
    end

    it 'adds validated non partner' do
      resp = described_class.add("some channel id")
      expect(resp).to eq(twirp_response)
    end
  end
end
