require 'rails_helper'

module Sessions
  describe Cookies do
    let(:creator_id) {'someotherID'}
    let(:user_id) {'someID'}
    let(:token) {"06em8z4vlk7pkwso5wk20vb1h3y82m"}
    let(:fake_response) {Service::Response.new(ActionDispatch::Response.new(200, {}, [{"token" => "#{token}"}.to_json]))}
    let(:ip_addr) {"192.168.1.1"}

    describe '#create' do
      it 'returns a new cookie create for the user' do
        cookie_params = {
            user_id: user_id,
            creator_id: creator_id,
            ip_address: ip_addr,
            location: "Hell, Michigan",
            user_agent: "Edge",
            expires_in: 5000,
        }
        request_params = {
            user_id: user_id,
            creator_id: creator_id,
            ip_address: ip_addr,
            location: "Hell, Michigan",
            user_agent: "Edge",
            expires_in: 5000,
            client_id: "",
        }

        allow(Sessions::Base).to receive(:post).with("/sessions", body: request_params.to_json).and_return(fake_response)
        expect_any_instance_of(History::SessionAudit).to receive(:add)

        result = Cookies.create(cookie_params)

        expect(result).to eq(token)
      end
    end
  end
end
