require 'rails_helper'

module Subscriptions
  describe Badge do
    include ServiceHelper

    describe 'destroy' do
      let(:id) { "my-badge-id" }
      let(:channel_id) { "my-channel-id" }
      let(:channel_tenure_method_id) { "#{channel_id}:1:CUMULATIVE"}

      let(:badge_response) do
        res = fake_get_response(200)
        expect(res).to receive(:success?).twice.and_return(true)
        res
      end

      it 'destroys a badge' do
        badge = Badge.new(id: id, channel_id: channel_id)

        expect(badge).to receive(:delete)
          .with("/internal/channels/#{channel_id}/badges/#{id}")
          .and_return(badge_response)

        expect(badge.destroy).to eql(true)
      end

      it 'destroys a badge with the new channel_tenure_method_id url param' do
        badge = Badge.new(
          id: id,
          channel_id: channel_id,
          channel_tenure_method_id: channel_tenure_method_id
        )

        expect(badge).to receive(:delete)
          .with("/internal/channels/#{channel_id}/badges/#{id}?channel_tenure_method_id=#{channel_tenure_method_id}")
          .and_return(badge_response)

        expect(badge.destroy).to eql(true)
      end
    end
  end
end