require 'rails_helper'

module Twitch
  RSpec.describe GlobalPrivilegedUsers do
    def fake_get_response(success)
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(success)

        allow(response).to receive(:body).and_return(
          "admins" => ["zelda", "samus", "mario"],
          "subadmins" => ["foo", "bar"],
          "global_mods" => ["frank", "suz"]
        )
      end
    end

    describe '#get' do
      it 'returns a list of admins, subadmins, and global_mod usersnames' do
        allow(Base).to receive(:get).and_return(fake_get_response(true))
        response = GlobalPrivilegedUsers.get

        expect(Base).to have_received(:get).with('/global_privileged_users')
        expect(response[:admins]).to eq(["zelda", "samus", "mario"])
        expect(response[:subadmins]).to eq(["foo", "bar"])
        expect(response[:global_mods]).to eq(["frank", "suz"])
      end

      it 'raises an exception if the request fails' do
        allow(Base).to receive(:get).and_return(fake_get_response(false))
        expect { GlobalPrivilegedUsers.get }.to raise_error GetGlobalPrivilegedUsersError
      end
    end
  end
end
