module TwitchSpec
  module Helpers
    def fake_user
      {
        "id" => 1_231_231_231,
        "login" => "doggo",
        "birthday" => "",
        "dmca_violation" => nil,
        "terms_of_service_violation" => nil,
        "deleted_on" => nil,
        "language" => "en",
        "category" => "gaming",
        "remote_ip" => "201.248.187.245",
        "location" => nil,
        "email" => "good@dog.woof",
        "last_login" => "2018-04-06 22:04:57",
        "banned_until" => nil,
        "dmca_violation_count" => nil,
        "tos_violation_count" => nil,
        "admin" => true,
        "subadmin" => false,
        "global_mod" => false,
        "displayname" => "doggo",
        "description" => "Hello? Yes this is dog",
        "profile_image" => {
          "150x150" => {},
          "28x28" => {},
          "300x300" => {},
          "50x50" => {},
          "600x600" => {},
          "70x70" => {}
        },
        "updated_on" => "2018-08-03T00:01:12.082963Z",
        "created_on" => "2016-06-07T07:55:55.638184Z",
        "email_verified" => true,
        "phone_number" => nil,
        "last_login_change_date" => nil
      }
    end

    def build_fake_response(success, body)
      Faraday::Response.new.tap do |response|
        allow(response).to receive(:success?).and_return(success)
        allow(response).to receive(:body).and_return("results" => body)
      end
    end
  end
end
