require 'rails_helper'
require_relative './helpers'

describe Twitch::UserChannelProperty do
  describe 'map_to_known_error' do
    let(:status) { '401' }
    let(:code) { 'unauthorized' }
    let(:message) { 'unknown error' }
    let(:response) do
      response = double('response')
      expect(response).to receive(:body).and_return({
        'Status' => status,
        'Code' => code,
        'Msg' => message
      }).at_least(:once)
      response
    end

    context 'not allowed to broadcast' do
      let(:message) { 'Not allowed to broadcast' }
      let(:expected) { "#{status} #{code}: #{message}, likely due to 2FA not being enabled." }

      it 'maps to the known error' do
        expect(described_class.map_to_known_error(response)).to eq(expected)
      end
    end

    context 'unknown' do
      let(:expected) { "#{status} #{code}: #{message}" }

      it 'maps to a default' do
        expect(described_class.map_to_known_error(response)).to eq(expected)
      end
    end
  end
end
