module Twitch
  describe User do
    describe 'tos_ban' do
      let(:user) { User.new(:id => "id") }
      description = "description"
      from_user_id = "from_user_id"

      let(:temp_ban_audit) do
        History::Audit.new(
          action: "ban_user",
          user_type: "ldap_user",
          user_id: from_user_id,
          resource_type: "twitch_user",
          resource_id: user.id,
          description: description,
          changes: []
        )
      end

      let(:perma_ban_audit) do
        History::Audit.new(
          action: "permaban_user",
          user_type: "ldap_user",
          user_id: from_user_id,
          resource_type: "twitch_user",
          resource_id: user.id,
          description: description,
          changes: []
        )
      end

      it 'creates enforcement for non-fraud' do
        expect(SupportTools::AegisGateway).to receive(:create_enforcement).with({
          content: "content",
          description: description,
          detailed_reason: "detailed_reason",
          from_user_id: from_user_id,
          ip_ban: true,
          origin: "web/admin-panel",
          permanent: false,
          reason: "reason",
          target_user_user_id: user.id.to_s,
         }).and_return(true)

        expect(History::AddAudit).to receive(:add).with(temp_ban_audit)

        expect(user.tos_ban({
          'content' => 'content',
          'reason' => 'reason',
          'detailed_reason' => 'detailed_reason',
          'description' => description,
          'reporter' => from_user_id,
          'skip_ip_ban' => 'false',
          'is_permanent' => 'false',
        })).to be true
      end

      it 'creates creates enforcement and refunds payment for fraud' do
        expect(SupportTools::AegisGateway).to receive(:create_enforcement).with({
          content: "purchase",
          description: description,
          detailed_reason: "detailed_reason",
          from_user_id: from_user_id,
          ip_ban: true,
          origin: "web/admin-panel",
          permanent: false,
          reason: "fraud",
          target_user_user_id: user.id.to_s,
        }).and_return(true)

        expect(History::AddAudit).to receive(:add).with(temp_ban_audit)
        expect(Payments::RefundAllPayments).to receive(:refund_all_payments).with(user.id, from_user_id, 'email', 60, description).and_return(true)

        expect(user.tos_ban({
          'content' => 'purchase',
          'reason' => 'fraud',
          'detailed_reason' => 'detailed_reason',
          'description' => description,
          'reporter' => from_user_id,
          'skip_ip_ban' => 'false',
          'is_permanent' => 'false',
          'reporter_email' => 'email',
        })).to be true
      end
    end
  end
end
