require "rails_helper"

describe TwitchNami::Balance do
  include ServiceHelper

  describe "#call" do
    describe "success" do
      let(:twirp_response) do
        data = Twitch::Fulton::Example::Twitchnami::GetBalanceResponse.new(
          user_balances: [
            Twitch::Fulton::Example::Twitchnami::Balance.new(
              amount: 100,
              currency: "USD",
              exponent: 2
            )
          ]
        )
        Twirp::ClientResp.new(data, nil)
      end

      before :each do
        expect(described_class.twirp_client).to(receive(:get_balance)).and_return(twirp_response)
      end

      it "retrieves balance" do
        response = described_class.call("1234")
        expect(response.user_balances.length).to eq(1)
        expect(response.user_balances[0].currency).to eq("USD")
      end
    end

    describe "error" do
      let(:twirp_response) { Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error", {})) }
      before :each do
        expect(described_class.twirp_client).to(receive(:get_balance)).and_return(twirp_response)
      end

      it "raises error" do
        expect { described_class.call("1234") }.to raise_error
      end
    end
  end
end
