require "rails_helper"

describe TwitchNami::WalletStatus do
  include ServiceHelper

  describe "#call" do
    describe "success" do
      let(:twirp_response) do
        data = Twitch::Fulton::Example::Twitchnami::UpdateWalletStatusResponse.new
        Twirp::ClientResp.new(data, nil)
      end

      before :each do
        expect(described_class.twirp_client).to(receive(:update_wallet_status)).and_return(twirp_response)
      end

      it "does not raise error" do
        expect { described_class.call("1234", Twitch::Fulton::Example::Twitchnami::WalletType::GIFT_CARD) }.not_to raise_error
      end
    end

    describe "error" do
      let(:twirp_response) { Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error", {})) }
      before :each do
        expect(described_class.twirp_client).to(receive(:update_wallet_status)).and_return(twirp_response)
      end

      it "raises error" do
        expect { described_class.call("1234", Twitch::Fulton::Example::Twitchnami::WalletType::GIFT_CARD) }.to raise_error
      end
    end
  end
end
