require "rails_helper"

describe TwitchZuko::RedemptionsHistory do
  include ServiceHelper

  include_context 'with s2s2'

  describe "#call" do
    describe "success" do
      let(:twirp_response) do
        data = Twitch::Fulton::Twitchzuko::GetRedemptionHistoryResponse.new(
          redemption_history: [
            Twitch::Fulton::Twitchzuko::RedemptionRecord.new(
              id: "1",
              user_id: "1234",
              redeem_amount: 1000,
              currency: "USD",
              serial_number: "serial_number",
              redemption_status: "redemption_status",
              vendor: "vendor",
              redemption_time: Google::Protobuf::Timestamp.new(seconds: 1)
            )
          ]
        )
        Twirp::ClientResp.new(data, nil)
      end

      before :each do
        expect(described_class.twirp_client).to(receive(:get_redemption_history)).and_return(twirp_response)
      end

      it "retrieves redemption history" do
        response = described_class.call("1234", "serial_number", "2019-09-10", "2019-10-10")

        expect(response.length).to eq(1)
        expect(response[0].currency).to eq("USD")
      end
    end

    describe "error" do
      let(:twirp_response) { Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error", {})) }
      before :each do
        expect(described_class.twirp_client).to(receive(:get_redemption_history)).and_return(twirp_response)
      end

      it "raises error" do
        expect { described_class.call("1234", "serial_number", "2019-09-10", "2019-10-10") }.to raise_error
      end
    end
  end
end
