require 'rails_helper'

RSpec.describe UserRewards::BitsBadgeTier do
  include ServiceHelper
  include Code::Justin::Tv::Commerce::Paydayrpc

  describe "#grant_unlocked_rewards" do
    describe "service succeeds" do

      let(:success_response) do
        data = Code::Justin::Tv::Commerce::Paydayrpc::AdminGrantUnlockedBadgeTierRewardsResp.new
        data.total_bits_cheered = 12345
        Twirp::ClientResp.new(data, nil)
      end

      it "returns the total bits cheered" do
        expect(described_class.twirp_client).to(receive(:admin_grant_unlocked_badge_tier_rewards).and_return(success_response))
        bits_cheered = described_class.grant_unlocked_rewards("123", "456")
        expect(bits_cheered).to eq(12345)
      end
    end

    describe "service fails" do
      let(:error_response) do
        Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error", {}))
      end

      it "throws an exception" do
        expect do
          expect(described_class.twirp_client).to(receive(:admin_grant_unlocked_badge_tier_rewards).and_return(error_response))
          described_class.grant_unlocked_rewards("123", "456")
        end.to raise_error "some error"
      end
    end
  end

  describe "#unlocked_emotes" do
    describe "service succeeds" do

      let(:success_response) do
        data = Code::Justin::Tv::Commerce::Paydayrpc::GetBitsBadgeTierEmotesResp.new
        data.emotes << Code::Justin::Tv::Commerce::Paydayrpc::BitsBadgeTierEmote.new(emote_id: "123", emote_code: "code")
        Twirp::ClientResp.new(data, nil)
      end

      it "returns the total bits cheered" do
        expect(described_class.twirp_client).to(receive(:get_bits_badge_tier_emotes).and_return(success_response))
        unlocked_emotes = described_class.unlocked_emotes("123", "456")
        expect(unlocked_emotes.size).to eq(1)
      end
    end

    describe "service fails" do
      let(:error_response) do
        Twirp::ClientResp.new(nil, Twirp::Error.new(:internal, "some error", {}))
      end

      it "throws an exception" do
        expect do
          expect(described_class.twirp_client).to(receive(:get_bits_badge_tier_emotes).and_return(error_response))
          described_class.unlocked_emotes("123", "456")
        end.to raise_error "some error"
      end
    end
  end
end