require 'rails_helper'

module Vods
  describe Vod do
    describe 'find' do
      let(:vod_id) { "987654" }
      let(:twirp_response) do
        vod = Mocks.vodapi_vod id: vod_id
        data = Vodapi::InternalGetVodByIDResponse.new vod: vod
        Twirp::ClientResp.new(data, nil)
      end

      before(:each) do
        expect(described_class.twirp_client).to receive(:internal_get_vod_by_i_d_include_banned_users).with(vod_id: vod_id).and_return(twirp_response)
      end

      it 'returns a vod' do
        check_attributes = [:id, :owner_id, :broadcast_id, :broadcast_type, :title, :game, :started_on, :uri, :offset, :duration, :status, :show_formats, :created_at, :updated_at, :views, :tag_list, :thumbnail_templates, :description, :broadcaster_software, :deleted, :created_by, :language, :delete_at, :manifest, :viewable_at, :origin]
        expected_attributes = {
          id: vod_id,
          owner_id: "7890",
          broadcast_type: :HIGHLIGHT,
          broadcast_id: "111",
          status: :RECORDED,
          offset: 0,
          thumbnail_templates: [],
          tag_list: [],
          uri: "",
          views: 0,
        }

        actual_vod = described_class.find(vod_id)
        expected_vod = Vod.new expected_attributes

        actual = actual_vod.serializable_hash.slice(*check_attributes)
        expected = expected_vod.serializable_hash.slice(*check_attributes)

        expect(actual).to eql(expected)
      end
    end
  end
end
