RSpec.shared_examples 'a twirp backed service' do
  context 'on twirp success' do
    let(:client) { double('client') }
    before(:each) do
      allow(described_class).to receive(:client).and_return(client)
      allow(client).to receive(twirp_method)
        .with(twirp_request)
        .and_return(Twirp::ClientResp.new(twirp_data, nil))
    end

    it 'returns an expected output' do
      expect(method.call).to eq(expected)
    end
  end

  context 'on twirp error' do
    let(:client) { double('client') }
    let(:error_msg) { 'my-msg' }

    before(:each) do
      allow(described_class).to receive(:client).and_return(client)
      allow(client).to receive(twirp_method)
        .with(twirp_request)
        .and_return(
          Twirp::ClientResp.new(
            nil,
            Twirp::Error.new(:internal, error_msg)
          )
        )
    end

    it 'raises error' do
      expect { method.call }.to raise_error(error_msg)
    end
  end
end
