provider "aws" {
  region = "us-west-2" #defaults
}

locals {
  alb_dns_name = "internal-admin-panel-canary-105902868.us-west-2.elb.amazonaws.com"

  # twitch-admin-panel-aws
  aws_account_alias = "twitch-admin-panel-aws"
  aws_account_id    = "196915980276"
  env               = "canary"
  domain            = "*.admin-panel.xarth.tv"
  osiris_domain     = "admin-panel-canary.osiris.xarth.tv"
  aws_region        = "us-west-2"

  vpc_id = "vpc-089eedfe9df4ad3a7"

  twitch_subnet = [
    "subnet-0a51cda3754e805ed",
    "subnet-044bcd89fa58bb83c",
    "subnet-01fd426b9040c1901",
  ]
}

provider "aws" {
  region = "${local.aws_region}"

  allowed_account_ids = [
    "${local.aws_account_id}",
  ]

  alias   = "${local.aws_account_alias}"
  profile = "${local.aws_account_alias}"
}

data "aws_security_group" "vpc-endpoints" {
  name = "${local.aws_account_alias}-vpc-endpoints"
}

data "aws_security_group" "nossl-vpc-endpoints" {
  name = "${local.aws_account_alias}-nossl-vpc-endpoints"
}

module "admin-panel-ecs-canary" {
  source = "../modules/admin-panel-ecs"

  aws_account_id = "${local.aws_account_id}"
  region         = "${local.aws_region}"
  environment    = "${local.env}"

  domain_name = "${local.domain}"

  twitch_subnet    = "${local.twitch_subnet}"
  twitch_subnet_sg = "sg-0c76f6c92e7f8890f"

  vpc_id           = "${local.vpc_id}"
  vpc_endpoints_sg = ["${data.aws_security_group.vpc-endpoints.id}", "${data.aws_security_group.nossl-vpc-endpoints.id}"]

  alarm_target_arn = ["arn:aws:sns:us-west-2:516651178292:sns-slack-admin-platform-alerts"]
  pushy_sns_topic  = "arn:aws:sns:us-west-2:603200399373:pushy_production_dispatch"

  alb_account_id = "797873946194"

  service_role_arns = [
    "arn:aws:iam::242470783240:role/alog/prod/alog-prod-invoke-all",

    // legacy activity log role arn. we can remove this once activity log is
    // fully migrated to a new account.
    "arn:aws:iam::958416494912:role/alog/production/alog-production-invoke-all",
  ]

  allowed_deployment_arns = [
    "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/admin-panel-production",
    "arn:aws:iam::516651178292:user/jenkins",
  ]
}

# production hosted images
module "image-upload-production" {
  source              = "../modules/image-upload"
  env                 = "${local.env}"
  upload_service_role = "arn:aws:iam::${local.aws_account_id}:role/admin-panel-${local.env}"
  cors_allowed_origin = ["https://${local.domain}", "https://${local.osiris_domain}"]

  lifecycle_rule_enabled         = false           # no lifecycle rules for production uploads
  lifecycle_rule_prefix          = "hosted_images"
  lifecycle_rule_expiration_days = 36500           # ...just in case        

  # explicitly pass the provider we want it to use
  providers = {
    aws = "aws.${local.aws_account_alias}"
  }
}
