module "privatelink" {
  source      = "git::git+ssh://git@git.xarth.tv/terraform-modules/privatelink-alb.git?ref=v0.0.4"
  account     = "twitch-admin-panel-aws"
  service     = "admin-panel"
  environment = "canary"
  dns_name    = "${local.alb_dns_name}"
  vpc         = "${local.vpc_id}"
  subnets     = "${local.twitch_subnet}"

  # acceptance managed by TPM
  vpc_endpoint_service_allowed_principals = ["internal"]
}
