resource "aws_cloudwatch_metric_alarm" "unhealthy_host_count" {
  alarm_name          = "admin-panel-${var.environment}-unhealthy-host-count"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold           = "1"
  period              = "300"
  evaluation_periods  = "2"
  statistic           = "Maximum"
  metric_name         = "UnHealthyHostCount"
  namespace           = "AWS/ApplicationELB"

  dimensions {
    LoadBalancer = "${aws_alb.app.arn_suffix}"
    TargetGroup  = "${aws_alb_target_group.app.arn_suffix}"
  }

  alarm_description = "Unhealthy host count for admin-panel ECS cluster"
  alarm_actions     = ["${var.alarm_target_arn}"]
  ok_actions        = ["${var.alarm_target_arn}"]
}

resource "aws_cloudwatch_metric_alarm" "500_response_codes" {
  alarm_name          = "admin-panel-${var.environment}-500_response_codes"
  comparison_operator = "GreaterThanThreshold"
  threshold           = "10"
  period              = "900"
  evaluation_periods  = "1"
  statistic           = "Sum"
  metric_name         = "HTTPCode_ELB_5XX_Count"
  namespace           = "AWS/ApplicationELB"
  treat_missing_data  = "notBreaching"

  dimensions {
    LoadBalancer = "${aws_alb.app.arn_suffix}"
    TargetGroup  = "${aws_alb_target_group.app.arn_suffix}"
  }

  alarm_description = "admin-panel returning 500 response codes"
  alarm_actions     = ["${var.alarm_target_arn}"]
  ok_actions        = ["${var.alarm_target_arn}"]
}

resource "aws_cloudwatch_metric_alarm" "high_latency" {
  alarm_name          = "admin-panel-${var.environment}-high_latency"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold           = "5"
  period              = "300"
  evaluation_periods  = "2"
  extended_statistic  = "p99"
  metric_name         = "TargetResponseTime"
  namespace           = "AWS/ApplicationELB"
  treat_missing_data  = "notBreaching"

  dimensions {
    LoadBalancer = "${aws_alb.app.arn_suffix}"
    TargetGroup  = "${aws_alb_target_group.app.arn_suffix}"
  }

  alarm_description = "admin-panel latency exceeding 5 seconds"
  alarm_actions     = ["${var.alarm_target_arn}"]
  ok_actions        = ["${var.alarm_target_arn}"]
}

resource "aws_cloudwatch_metric_alarm" "high_cpu" {
  alarm_name          = "admin-panel-${var.environment}-high_cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold           = "80"
  period              = "300"
  evaluation_periods  = "2"
  statistic           = "Average"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/ECS"
  treat_missing_data  = "notBreaching"

  dimensions {
    ClusterName = "admin-panel-${var.environment}"
    ServiceName = "admin-panel-${var.environment}"
  }

  alarm_description = "admin-panel cpu usage exceeding 80%"
  alarm_actions     = ["${var.alarm_target_arn}"]
  ok_actions        = ["${var.alarm_target_arn}"]
}

resource "aws_cloudwatch_metric_alarm" "high_memory" {
  alarm_name          = "admin-panel-${var.environment}-high_memory"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold           = "80"
  period              = "300"
  statistic           = "Average"
  evaluation_periods  = "2"
  metric_name         = "MemoryUtilization"
  namespace           = "AWS/ECS"
  treat_missing_data  = "notBreaching"

  dimensions {
    ClusterName = "admin-panel-${var.environment}"
    ServiceName = "admin-panel-${var.environment}"
  }

  alarm_description = "admin-panel memory usage exceeding 80%"
  alarm_actions     = ["${var.alarm_target_arn}"]
  ok_actions        = ["${var.alarm_target_arn}"]
}
