locals {
  security_groups = [
    "${var.twitch_subnet_sg}",
    "${aws_security_group.jobs.id}",
    "${aws_security_group.memcache.id}",
  ]
}

resource "aws_ecs_cluster" "app" {
  name = "admin-panel-${var.environment}"
}

resource "aws_ecs_service" "app" {
  name            = "admin-panel-${var.environment}"
  cluster         = "${aws_ecs_cluster.app.id}"
  task_definition = "${aws_ecs_task_definition.app.arn}"
  desired_count   = 1
  launch_type     = "FARGATE"

  load_balancer {
    target_group_arn = "${aws_alb_target_group.app.arn}"
    container_name   = "admin-panel-${var.environment}"
    container_port   = "8000"
  }

  network_configuration {
    security_groups = [
      "${concat(
          local.security_groups,
          var.vpc_endpoints_sg
        )}",
    ]

    subnets = [
      "${var.twitch_subnet}",
    ]
  }

  lifecycle {
    ignore_changes = [
      "task_definition",
      "desired_count",
    ]
  }
}

resource "aws_ecs_task_definition" "app" {
  family                   = "admin-panel-${var.environment}"
  network_mode             = "awsvpc"
  requires_compatibilities = ["FARGATE"]
  cpu                      = "1024"
  memory                   = "2048"
  execution_role_arn       = "${aws_iam_role.execution.arn}"
  task_role_arn            = "${aws_iam_role.app.arn}"

  container_definitions = <<DEFINITION
[
  {
    "cpu": 1024,
    "essential": true,
    "image": "${aws_ecr_repository.app.repository_url}:latest",
    "memory": 2048,
    "command": ["./scripts/rails-launcher.sh"],
    "name": "admin-panel-${var.environment}",
    "networkMode": "awsvpc",
    "logConfiguration": {
      "logDriver": "awslogs",
      "options": {
        "awslogs-group": "${aws_cloudwatch_log_group.app.name}",
        "awslogs-region": "${var.region}",
        "awslogs-stream-prefix": "admin-panel-${var.environment}"
      }
    },
    "environment": [
        {
            "name": "ENVIRONMENT",
            "value": "${var.environment}"
        }
    ],
    "portMappings": [
      {
        "containerPort": 8000
      }
    ]
  }
]
  DEFINITION

  lifecycle {
    ignore_changes = [
      "container_definition",
    ]
  }
}
