resource "aws_elasticache_subnet_group" "jobs" {
  name       = "general-elasticache-subnets-${var.environment}"
  subnet_ids = ["${var.twitch_subnet}"]
}

resource "aws_security_group" "jobs" {
  name        = "ap-jobs-${var.environment}"
  description = "allow access to admin-panel jobs redis cache"
  vpc_id      = "${var.vpc_id}"

  ingress {
    from_port = 6379
    to_port   = 6379
    protocol  = "tcp"
    self      = true
  }

  tags {
    Name = "admin-panel-jobs-${var.environment}"
  }
}

resource "aws_elasticache_replication_group" "jobs" {
  automatic_failover_enabled    = true
  engine_version                = "3.2.4"
  maintenance_window            = "thu:10:00-thu:11:00"
  node_type                     = "cache.r3.large"
  number_cache_clusters         = 2
  parameter_group_name          = "default.redis3.2"
  port                          = 6379
  replication_group_id          = "ap-jobs-${var.environment}"
  replication_group_description = "Used by resque"
  snapshot_window               = "07:00-08:00"
  security_group_ids            = ["${aws_security_group.jobs.id}"]
  subnet_group_name             = "general-elasticache-subnets-${var.environment}"
}

resource "aws_security_group" "memcache" {
  name        = "ap-memcache-${var.environment}"
  description = "allow access to admin-panel memcache"
  vpc_id      = "${var.vpc_id}"

  ingress {
    from_port = 11211
    to_port   = 11211
    protocol  = "tcp"
    self      = true
  }

  tags {
    Name = "admin-panel-memcache-${var.environment}"
  }
}

resource "aws_elasticache_cluster" "memcache" {
  cluster_id           = "ap-mem-${var.environment}"
  engine               = "memcached"
  node_type            = "cache.m3.medium"
  num_cache_nodes      = 1
  parameter_group_name = "default.memcached1.4"
  subnet_group_name    = "general-elasticache-subnets-${var.environment}"
  security_group_ids   = ["${aws_security_group.memcache.id}"]
  port                 = 11211
  maintenance_window   = "sat:10:00-sat:11:00"
}
