resource "aws_ecs_service" "http-redirect" {
  name            = "admin-panel-http-redirect-${var.environment}"
  cluster         = "${aws_ecs_cluster.app.id}"
  task_definition = "${aws_ecs_task_definition.http-redirect.arn}"
  desired_count   = 1
  launch_type     = "FARGATE"

  load_balancer {
    target_group_arn = "${aws_alb_target_group.http.arn}"
    container_name   = "main"
    container_port   = "80"
  }

  network_configuration {
    security_groups = [
      "${var.twitch_subnet_sg}",
    ]

    subnets = [
      "${var.twitch_subnet}",
    ]
  }

  lifecycle {
    ignore_changes = [
      "task_definition",
      "desired_count",
    ]
  }
}

resource "aws_ecs_task_definition" "http-redirect" {
  family                   = "admin-panel-http-redirect-${var.environment}"
  network_mode             = "awsvpc"
  requires_compatibilities = ["FARGATE"]
  cpu                      = "256"
  memory                   = "512"
  execution_role_arn       = "${aws_iam_role.execution.arn}"

  container_definitions = <<DEFINITION
[
  {
    "essential": true,
    "image": "${aws_ecr_repository.app.repository_url}:local-http",
    "name": "main",
    "networkMode": "awsvpc",
    "logConfiguration": {
      "logDriver": "awslogs",
      "options": {
        "awslogs-group": "${aws_cloudwatch_log_group.app.name}",
        "awslogs-region": "${var.region}",
        "awslogs-stream-prefix": "http-redirect"
      }
    },
    "portMappings": [
      {
        "containerPort": 80
      }
    ]
  }
]
  DEFINITION

  lifecycle {
    ignore_changes = [
      "container_definition",
    ]
  }
}
