variable "environment" {}

variable "region" {}
variable "twitch_subnet_sg" {}

variable "twitch_subnet" {
  type = "list"
}

variable "vpc_id" {}

variable "aws_account_id" {}

variable "service_role_arns" {
  type        = "list"
  description = "List of IAM role arns that admin panel can assume."
}

variable "alarm_target_arn" {
  type = "list"
}

variable "domain_name" {}

variable "allowed_deployment_arns" {
  type = "list"
}

variable "alb_account_id" {
  description = "Account ID alb is in. See https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html"
}

variable "vpc_endpoints_sg" {
  type = "list"
}

variable "pushy_sns_topic" {
  description = "sns topic used for pushy dispatch."
}

locals {
  root_arn = "arn:aws:iam::${var.aws_account_id}:root"
}
