resource "aws_route53_resolver_endpoint" "endpoint" {
  name      = "${var.environment}-vpc-outbound-dns"
  direction = "OUTBOUND"

  security_group_ids = [
    "${var.twitch_subnets_sg_id}",
  ]

  ip_address {
    subnet_id = "${element(var.subnets, 0)}"
  }

  ip_address {
    subnet_id = "${element(var.subnets, 1)}"
  }

  ip_address {
    subnet_id = "${element(var.subnets, 2)}"
  }

  tags {
    Environment = "${var.environment}"
  }
}

resource "aws_route53_resolver_rule" "fwd_justin" {
  domain_name          = "justin.tv"
  name                 = "fwd_justin_tv_dns_cache"
  rule_type            = "FORWARD"
  resolver_endpoint_id = "${aws_route53_resolver_endpoint.endpoint.id}"

  target_ip {
    ip = "${element(var.ip_addresses, 0)}"
  }

  target_ip {
    ip = "${element(var.ip_addresses, 1)}"
  }

  target_ip {
    ip = "${element(var.ip_addresses, 2)}"
  }

  target_ip {
    ip = "${element(var.ip_addresses, 3)}"
  }

  tags {
    Environment = "${var.environment}"
  }
}

resource "aws_route53_resolver_rule" "fwd_uswest2_twitch" {
  domain_name          = "us-west2.twitch.tv"
  name                 = "fwd_uswest2-twitch_tv_dns_cache"
  rule_type            = "FORWARD"
  resolver_endpoint_id = "${aws_route53_resolver_endpoint.endpoint.id}"

  target_ip {
    ip = "${element(var.ip_addresses, 0)}"
  }

  target_ip {
    ip = "${element(var.ip_addresses, 1)}"
  }

  target_ip {
    ip = "${element(var.ip_addresses, 2)}"
  }

  target_ip {
    ip = "${element(var.ip_addresses, 3)}"
  }

  tags {
    Environment = "${var.environment}"
  }
}

resource "aws_route53_resolver_rule_association" "justin" {
  resolver_rule_id = "${aws_route53_resolver_rule.fwd_justin.id}"
  vpc_id           = "${var.vpc_id}"
}

resource "aws_route53_resolver_rule_association" "uswest2-twitch" {
  resolver_rule_id = "${aws_route53_resolver_rule.fwd_uswest2_twitch.id}"
  vpc_id           = "${var.vpc_id}"
}
