# Adding admin-panel VPC endpoints (Private Links) for external service owners

This document is for service owners (i.e. bits, chat, etc.) that want to enable
access to their service from admin panel.

VPC endpoints (private links) are used to enable networking between AWS
accounts. This document goes over how to receive a VPC endpoint for a service
located in another account from admin panel. This **does not** go over how to
provide a VPC endpoint from the Admin Panel AWS accounts.

![Architecture](./architecture.png "Architecture")

## Things you will need

### Which environment you want to add an endpoint for

Admin panel has two AWS accounts.

| account name | number | serves | environment | 
| --- | --- | --- | --- | 
| twitch-admin-panel-aws | 196915980276 | admin-panel.internal.justin.tv <br> admin-panel-canary.internal.justin.tv | production |
| twitch-admin-panel-dev | 219087926005 | admin-panel-staging.internal.justin.tv | staging | 

The terraform for those are in `./terraform/<account-name>`.

### A VPC endpoint service name from the external service's AWS account

The VPC endpoint your external service is serving on. You should set this up in
the service's account. Should looks something like
`com.amazonaws.vpce.us-west-2.vpce-svc-ABCDEF`.

### A TLS certificate that is served by your service

Admin panel only accepts TLS secured TCP traffic on 443. This process will add
an DNS CNAME entry to resolve to the DNS entry associated with the VPC endpoint.
The certificate that your service is serving must be valid for the DNS CNAME
entry.

## Process for external service owners

1. Open a PR adding a module that references `./terraform/modules/vpc-endpoint`
   with all the variables provided in
   `./terraform/<account-name>/vpc-endpoints.tf`.
2. We will review your review and respond with feedback with normal PR SLAs.

Once applied, this will:

1. Create a VPC endpoint to link your service.
2. A DNS entry only resolvable in the admin-panel VPC.
