resource "aws_vpc_endpoint" "main" {
  vpc_id              = "${var.vpc_id}"
  service_name        = "${var.service_name}"
  vpc_endpoint_type   = "Interface"
  private_dns_enabled = false
  security_group_ids  = ["${var.security_groups}"]
  subnet_ids          = ["${var.subnet_ids}"]
}

resource "aws_route53_zone" "main" {
  name    = "${var.service_dns_entry}"
  comment = "Private zone for VPC endpoints.."

  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

resource "aws_route53_record" "main" {
  zone_id = "${aws_route53_zone.main.id}"
  name    = "${var.service_dns_entry}"
  type    = "A"

  alias {
    name                   = "${aws_vpc_endpoint.main.dns_entry.0.dns_name}"
    zone_id                = "${aws_vpc_endpoint.main.dns_entry.0.hosted_zone_id}"
    evaluate_target_health = true
  }
}

resource "aws_route53_record" "admin-panel" {
  zone_id = "${aws_route53_zone.main.id}"
  name    = "admin-panel.${var.service_dns_entry}"
  type    = "A"

  alias {
    name                   = "${aws_vpc_endpoint.main.dns_entry.0.dns_name}"
    zone_id                = "${aws_vpc_endpoint.main.dns_entry.0.hosted_zone_id}"
    evaluate_target_health = true
  }
}
