provider "aws" {
  region = "us-west-2" #defaults
}

locals {
  alb_dns_name = "internal-admin-panel-staging-72825120.us-west-2.elb.amazonaws.com"

  # twitch-admin-panel-dev
  aws_account_alias = "twitch-admin-panel-dev"
  aws_account_id    = "219087926005"
  env               = "staging"
  domain            = "staging.admin-panel.xarth.tv"
  osiris_domain     = "admin-panel-staging.osiris.xarth.tv"
  aws_region        = "us-west-2"

  vpc_id = "vpc-0a85600bbd1aed6f5"

  twitch_subnet = [
    "subnet-0cadddd78b4c89c78",
    "subnet-095a737b8c52df148",
    "subnet-0273de04e1e1d8d5c",
  ]
}

provider "aws" {
  region = "${local.aws_region}"

  allowed_account_ids = [
    "${local.aws_account_id}",
  ]

  alias   = "${local.aws_account_alias}"
  profile = "${local.aws_account_alias}"
}

data "aws_security_group" "vpc-endpoints" {
  name = "${local.aws_account_alias}-vpc-endpoints"
}

data "aws_security_group" "nossl-vpc-endpoints" {
  name = "${local.aws_account_alias}-nossl-vpc-endpoints"
}

module "admin-panel-ecs-staging" {
  source = "../modules/admin-panel-ecs"

  aws_account_id = "${local.aws_account_id}"
  region         = "${local.aws_region}"
  environment    = "${local.env}"

  domain_name = "${local.domain}"

  twitch_subnet    = "${local.twitch_subnet}"
  twitch_subnet_sg = "sg-04f2086ae714dca07"

  vpc_id           = "${local.vpc_id}"
  vpc_endpoints_sg = ["${data.aws_security_group.vpc-endpoints.id}", "${data.aws_security_group.nossl-vpc-endpoints.id}"]

  alarm_target_arn = ["arn:aws:sns:us-west-2:516651178292:sns-slack-admin-platform-alerts"]
  pushy_sns_topic  = "arn:aws:sns:us-west-2:603200399373:pushy_darklaunch_dispatch"

  alb_account_id = "797873946194"

  service_role_arns = [
    "arn:aws:iam::701850219792:role/alog/${local.env}/alog-staging-invoke-all",

    // legacy activity log role arn. we can remove this once activity log is
    // fully migrated to a new account.
    "arn:aws:iam::005087123760:role/alog/${local.env}/alog-staging-invoke-all",
  ]

  allowed_deployment_arns = [
    "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/admin-panel-${local.env}",
    "arn:aws:iam::516651178292:user/jenkins",
  ]
}

# staging hosted images
module "image-upload-staging" {
  source              = "../modules/image-upload"
  env                 = "${local.env}"
  upload_service_role = "arn:aws:iam::${local.aws_account_id}:role/admin-panel-${local.env}"
  cors_allowed_origin = ["https://${local.domain}", "https://${local.osiris_domain}"]

  lifecycle_rule_enabled         = true
  lifecycle_rule_prefix          = "hosted_images"
  lifecycle_rule_expiration_days = 60              # two months for staging files seems fine

  # explicitly pass the provider we want it to use
  providers = {
    aws = "aws.${local.aws_account_alias}"
  }
}

# local dev hosted images
module "image-upload-local-dev" {
  source              = "../modules/image-upload"
  env                 = "dev"
  upload_service_role = "arn:aws:iam::${local.aws_account_id}:role/dev"

  cors_allowed_origin = [
    "http://127.0.0.1:3000",
    "https://127.0.0.1:3000",
    "http://localhost:3000",
    "https://localhost:3000",
  ]

  lifecycle_rule_enabled         = true
  lifecycle_rule_prefix          = "hosted_images"
  lifecycle_rule_expiration_days = 7               # local dev files shouldn't remain for very long

  # explicitly pass the provider we want it to use
  providers = {
    aws = "aws.${local.aws_account_alias}"
  }
}
