// VPC endpoints to other Twitch AWS accounts. Please see
// ../modules/vpc-endpoint/README.md for instructions.

data "aws_cloudformation_stack" "teleport-remote-jumpbox" {
  name = "teleport-remote-twitch-admin-panel-prod-us-west-2-JumpboxStack-10S3U0ZMB2DG0"
}

resource "aws_security_group" "vpc-endpoints" {
  name        = "${local.prefix}-vpc-endpoints"
  description = "allow all traffic to and from our vpc endpoints"
  vpc_id      = "${local.vpc_id}"

  ingress {
    from_port       = 443
    to_port         = 443
    protocol        = "tcp"
    self            = "true"
    security_groups = ["${data.aws_cloudformation_stack.teleport-remote-jumpbox.outputs.SecurityGroup}"]
  }

  ingress {
    description     = "LDAP"
    from_port       = 636
    to_port         = 636
    protocol        = "tcp"
    self            = "true"
    security_groups = ["${data.aws_cloudformation_stack.teleport-remote-jumpbox.outputs.SecurityGroup}"]
  }

  tags {
    Name = "${local.prefix}-vpc-endpoints"
  }
}

resource "aws_security_group" "nossl-vpc-endpoints" {
  name        = "${local.prefix}-nossl-vpc-endpoints"
  description = "allow all non-ssl traffic to and from our vpc endpoints"
  vpc_id      = "${local.vpc_id}"

  ingress {
    from_port       = 80
    to_port         = 80
    protocol        = "tcp"
    self            = "true"
    security_groups = ["${data.aws_cloudformation_stack.teleport-remote-jumpbox.outputs.SecurityGroup}"]
  }

  tags {
    Name = "${local.prefix}-nossl-vpc-endpoints"
  }
}

module "prometheus-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prometheus.internal.justin.tv"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-06f40cb9451599c4d"
  vpc_id            = "${local.vpc_id}"
}

module "prometheus-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.prometheus.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0624fd6582168338a"
  vpc_id            = "${local.vpc_id}"
}

// TODO: remove once change to point at petozi a2z dns is merged/deployed
module "petozi-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production.petozi.internal.justin.tv"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e5642c1438fcc295"
  vpc_id            = "${local.vpc_id}"
}

module "petozi-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.petozi.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e5642c1438fcc295"
  vpc_id            = "${local.vpc_id}"
}

module "beefcake-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "beefcake.prod.internal.justin.tv"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0adad5b062880221c"
  vpc_id            = "${local.vpc_id}"
}

module "multiplex-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production-internal.multiplex.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-067bd16a03d8c9f60"
  vpc_id            = "${local.vpc_id}"
}

module "galleon-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.galleon.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07e23d7f887b5959d"
  vpc_id            = "${local.vpc_id}"
}

module "revenuereportingworkers-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.revenuereporting-workers.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04daa31fc3443c691"
  vpc_id            = "${local.vpc_id}"
}

module "phanto-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.phanto.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03e0dcad51354e379"
  vpc_id            = "${local.vpc_id}"
}

// TODO: remove once change to point at pachter a2z dns is merged/deployed
module "pachter-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production.pachter.internal.justin.tv"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0acadbee6cda24e42"
  vpc_id            = "${local.vpc_id}"
}

module "pachter-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.pachter.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0acadbee6cda24e42"
  vpc_id            = "${local.vpc_id}"
}

module "percy-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.percy.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e6ddad325c9d1610"
  vpc_id            = "${local.vpc_id}"
}

module "nami-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.twitchnami.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03ca5f5136eb19710"
  vpc_id            = "${local.vpc_id}"
}

module "zuko-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.twitchzuko.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e99cdbc6992f52e5"
  vpc_id            = "${local.vpc_id}"
}

module "dart-receiver-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production.receiver.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04bef8bdac64fa932"
  vpc_id            = "${local.vpc_id}"
}

module "siosa-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.siosa.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-051f619541b025982"
  vpc_id            = "${local.vpc_id}"
}

module "corleone-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.corleone.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-08a5e6571fe9e9ba6"
  vpc_id            = "${local.vpc_id}"
}

# module "twitchcategoryindexer-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.twitchcategoryindexer.s.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04e5af2ce226ff33c"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/380/endpoints
module "ipblock-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "ipblock.service.safety.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050fdf0115b5a9a10"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/67/endpoints
module "saul-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.saul.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03b9894a5dac3edd6"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/302/endpoints
# module "history-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.twitchhistoryservice.s.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0969315074650008c"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/297/endpoints
module "roster-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.roster.cb.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0308340fe7b6cc3e1"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/167/endpoints
module "channel-properties-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "visage.channel-properties.video.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d87e74d88919fd6c"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/173/endpoints
module "discovery-categorydb-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.oldcategorydb.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03580e04235e0da93"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/127/endpoints
module "guardian-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.guardian.services.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-039dcfa9417c933ab"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/351/endpoints
module "mulan-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.mulan.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-024bde07637f35efc"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/314/endpoints
module "subscriptions-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.subscriptions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0da600ed5479b2bbc"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/22/endpoints
module "ldap-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "ldap.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0437151f68c61b808"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/324/endpoints
module "aegis-gateway-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "gateway.service.safety.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050fdf0115b5a9a10"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/42/endpoints
module "drops-registry-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.registry.vhs.extensions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0b2c735e3cdbbc67d"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/368/endpoints
module "graffiti-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production.graffiti.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0f4035716d5c8a71f"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/356/endpoints
module "dmca-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "apiserver-dmca.service.safety.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050fdf0115b5a9a10"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/531/endpoints
module "chronobreak-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.chronobreak.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03b77fb05fa369510"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/3/endpoints 
# SSL: true 
# PORT: 443 
module "users-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.users-service.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-044e493c84b7dc984"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/4/endpoints 
# SSL: true 
# PORT: 443 
module "connections-production-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.connections.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07cde4726544f4a54"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/7/endpoints 
# SSL: true 
# PORT: 443 
module "sso-production-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.sso.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0bbcdb19afe6b0d48"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/11/endpoints 
# SSL: true 
# PORT: 443 
module "owl-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.owl.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-08fdcf80669bbcb87"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/12/endpoints 
# SSL: true 
# PORT: 443 
module "badges-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.badges.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03a967196cfcb83ac"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/22/endpoints 
# # SSL: true 
# # PORT: 636 
# module "ldap-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "ldap.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0437151f68c61b808"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/42/endpoints 
# # SSL: true 
# # PORT: 443 
# module "vhs-drops-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.registry.vhs.extensions.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0b2c735e3cdbbc67d"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/47/endpoints 
# SSL: true 
# PORT: 443 
# module "moneypenny-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.moneypenny.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.peering-only-0.vpce-svc-unconfigured"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/51/endpoints 
# # SSL: true 
# # PORT: 443 
# module "revenue-reporting-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.revenuereporting-workers.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04daa31fc3443c691"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/67/endpoints 
# # SSL: true 
# # PORT: 443 
# module "saul-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.saul.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03b9894a5dac3edd6"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/75/endpoints 
# SSL: true 
# PORT: 443 
module "tmi-clue-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.clue.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0bc8ad3dc47e31c8f"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/86/endpoints 
# SSL: true 
# PORT: 443 
module "passport-prod-int-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "internal.passport.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-08b3dffb6bc2ee157"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/95/endpoints 
# SSL: false 
# PORT: 80 
module "followingservice-production-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production.following-service.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0a95189a54a27c686"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/96/endpoints 
# SSL: true 
# PORT: 443 
# module "payments-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.payments-service.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.peering-only-0.vpce-svc-unconfigured"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/103/endpoints 
# SSL: true 
# PORT: 443 
module "mako-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.mako.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050e9a8fff6ba9c06"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/127/endpoints 
# # SSL: true 
# # PORT: 443 
# module "guardian-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.guardian.services.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-039dcfa9417c933ab"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/159/endpoints 
# SSL: true 
# PORT: 443 
module "spade-di--prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "spade.internal.di.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-080f691601ce37dfb"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/167/endpoints 
# # SSL: false 
# # PORT: 80 
# module "channelproperties-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "visage.channel-properties.video.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d87e74d88919fd6c"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/173/endpoints 
# SSL: true 
# PORT: 443 
module "categorydb-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.twitchcategorydb.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0cdc1578058001e8e"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/173/endpoints 
# # SSL: false 
# # PORT: 80 
# module "categorydb-prod-old-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.oldcategorydb.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03580e04235e0da93"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/182/endpoints 
# SSL: true 
# PORT: 443 
module "payday-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.payday.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07a49906f8e043689"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/192/endpoints 
# SSL: true 
# PORT: 443 
module "zuma-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.zuma.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0f17f4a13ccd2383b"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/297/endpoints 
# # SSL: false 
# # PORT: 80 
# module "cb-roster-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.roster.cb.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0308340fe7b6cc3e1"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/302/endpoints 
# SSL: true 
# PORT: 443 
module "history-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.twitchhistoryservice.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0969315074650008c"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/303/endpoints 
# SSL: true 
# PORT: 443 
module "beefcake-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "primary.us-west-2.prod.twitchbeefcake.services.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0adad5b062880221c"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/314/endpoints 
# # SSL: true 
# # PORT: 443 
# module "subscriptions-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.subscriptions.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0da600ed5479b2bbc"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/324/endpoints 
# # SSL: true 
# # PORT: 443 
# module "gateway-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "gateway.service.safety.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050fdf0115b5a9a10"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/351/endpoints 
# # SSL: true 
# # PORT: 443 
# module "mulan-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "prod.mulan.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-024bde07637f35efc"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/352/endpoints 
# SSL: true 
# PORT: 443 
module "ripley-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.ripley.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e9e8a2896b1d5e89"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/356/endpoints 
# # SSL: true 
# # PORT: 443 
# module "dmca-tool-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "apiserver-dmca.service.safety.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050fdf0115b5a9a10"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/368/endpoints 
# # SSL: true 
# # PORT: 443 
# module "graffiti-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "production.graffiti.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0f4035716d5c8a71f"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/379/endpoints 
# SSL: true 
# PORT: 443 
module "valhalla-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.prod.valhalla.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-016505977886ea060"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/380/endpoints 
# # SSL: true 
# # PORT: 443 
# module "ip-blocks-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "ipblock.service.safety.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-050fdf0115b5a9a10"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/386/endpoints 
# SSL: true 
# PORT: 443 
module "everdeen-production-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.everdeen.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e3f15bfd3281c3ab"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/388/endpoints 
# SSL: true 
# PORT: 443 
module "vodapi-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "production.vodapi.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d03f1366bb1966a9"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/421/endpoints 
# # SSL: true 
# # PORT: 443 
# module "prometheus-Prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.prometheus.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0624fd6582168338a"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/448/endpoints 
# SSL: true 
# PORT: 443 
module "rbac-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.devsite-rbac.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0ced7ed5454280b71"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/455/endpoints 
# SSL: true 
# PORT: 443 
module "sessions-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.twitchidentitysessions.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-08dd8dc3c97e5054f"
  vpc_id            = "${local.vpc_id}"
}

# # https://catalog.xarth.tv/services/488/endpoints 
# # SSL: true 
# # PORT: 443 
# module "siosa-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.siosa.s.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-051f619541b025982"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/531/endpoints 
# # SSL: true 
# # PORT: 443 
# module "chronobreak-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.chronobreak.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03b77fb05fa369510"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/542/endpoints 
# SSL: true 
# PORT: 443 
# module "ad-revenue-api-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "production.ad-revenue-config.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.peering-only-0.vpce-svc-unconfigured"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/553/endpoints 
# # SSL: true 
# # PORT: 443 
# module "galleon-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.galleon.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0bf9eb64878fc3242"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/585/endpoints 
# # SSL: true 
# # PORT: 443 
# module "multiplex-prod-internal-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "production-internal.multiplex.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-067bd16a03d8c9f60"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/594/endpoints 
# # SSL: true 
# # PORT: 443 
# module "corleone-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.corleone.s.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-08a5e6571fe9e9ba6"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/595/endpoints 
# # SSL: true 
# # PORT: 443 
# module "receiver-production-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "production.receiver.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04bef8bdac64fa932"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/638/endpoints 
# # SSL: true 
# # PORT: 443 
# module "pachter-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.pachter.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0acadbee6cda24e42"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/659/endpoints 
# # SSL: true 
# # PORT: 443 
# module "percy-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.percy.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e6ddad325c9d1610"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/722/endpoints 
# # SSL: true 
# # PORT: 443 
# module "zuko-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "us-west-2.prod.twitchzuko.s.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0e99cdbc6992f52e5"
#   vpc_id            = "${local.vpc_id}"
# }

# # https://catalog.xarth.tv/services/726/endpoints 
# # SSL: true 
# # PORT: 443 
# module "nami-prod-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"

#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "main.us-west-2.prod.twitchnami.s.twitch.a2z.com"
#   service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03ca5f5136eb19710"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/759/endpoints 
# SSL: true 
# PORT: 443 
module "category-indexer-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.prod.twitchcategoryindexer.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04e5af2ce226ff33c"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/???/endpoints 
# SSL: true 
# PORT: 443 
module "boxart-extensions-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.boxart.extensions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-044ed75ae279d5a77"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/144/endpoints
# SSL: false
# PORT: 80
module "hypeman-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "prod.hypeman.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07afd8f21ce0fd859"
  vpc_id            = "${local.vpc_id}"
}

# CHaOS Sentry instance
module "sentry-chaos-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${split(",", replace(join(",", local.subnet_ids),"subnet-044bcd89fa58bb83c,",""))}"] # sentry is not in us-west-2c
  service_dns_entry = "sentry.chaos.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d5a7353af460713c"
  vpc_id            = "${local.vpc_id}"
}
