// VPC endpoints to other Twitch AWS accounts. Please see
// ../modules/vpc-endpoint/README.md for instructions.

data "aws_cloudformation_stack" "teleport-remote-jumpbox" {
  name = "teleport-remote-twitch-admin-panel-staging-us-west-2-JumpboxStack-196S1C9GD4CEC"
}

resource "aws_security_group" "vpc-endpoints" {
  name        = "${local.prefix}-vpc-endpoints"
  description = "allow all traffic to and from our vpc endpoints"
  vpc_id      = "${local.vpc_id}"

  ingress {
    from_port       = 443
    to_port         = 443
    protocol        = "tcp"
    self            = "true"
    security_groups = ["${data.aws_cloudformation_stack.teleport-remote-jumpbox.outputs.SecurityGroup}"]
  }

  ingress {
    description     = "LDAP"
    from_port       = 636
    to_port         = 636
    protocol        = "tcp"
    self            = "true"
    security_groups = ["${data.aws_cloudformation_stack.teleport-remote-jumpbox.outputs.SecurityGroup}"]
  }

  tags {
    Name = "${local.prefix}-vpc-endpoints"
  }
}

resource "aws_security_group" "nossl-vpc-endpoints" {
  name        = "${local.prefix}-nossl-vpc-endpoints"
  description = "allow all non-ssl traffic to and from our vpc endpoints"
  vpc_id      = "${local.vpc_id}"

  ingress {
    from_port       = 80
    to_port         = 80
    protocol        = "tcp"
    self            = "true"
    security_groups = ["${data.aws_cloudformation_stack.teleport-remote-jumpbox.outputs.SecurityGroup}"]
  }

  tags {
    Name = "${local.prefix}-nossl-vpc-endpoints"
  }
}

# https://catalog.xarth.tv/services/421/endpoints
module "prometheus-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.prometheus.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-034e0f295eb95d20f"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/637/endpoints
module "petozi-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.petozi.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07b64710c641bdf45"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/303/endpoints
module "beefcake-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "primary.us-west-2.beta.twitchbeefcake.services.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0640a728ae93eee38"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/585/endpoints
module "digestion-multiplex-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.multiplex.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0dc2e6960f0517893"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/553/endpoints
module "galleon-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.galleon.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-090d79b1551b69c78"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/51/endpoints
module "revenuereportingworkers-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "dev.revenuereporting-workers.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0cfb2fc8a4c75bdfd"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/369/endpoints
module "phanto-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.phanto.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0fc564f4f9a59cb32"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/638/endpoints
module "pachter-a2z-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.pachter.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0478140ad85946ce0"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/659/endpoints
module "percy-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.percy.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0b0e0a8dc77a2b713"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/726/endpoints
module "nami-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.twitchnami.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0ebc8768f8d055442"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/722/endpoints
module "zuko-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.twitchzuko.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0bf6576abbb941035"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/595/endpoints
module "dart-receiver-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.receiver.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0796a8b920e1d6946"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/488/endpoints
module "siosa-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.beta.siosa.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03f87c75cbb0c5230"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/594/endpoints
module "corleone-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.beta.corleone.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-04e8b100819ae6104"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/759/endpoints
module "twitchcategoryindexer-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.beta.twitchcategoryindexer.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0399ca5e763d019d2"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/12/endpoints
module "badges-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.badges.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-05cfe1ccfde6ecb1b"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/531/endpoints
module "chronobreak-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.chronobreak.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0f163b9d7e3f95634"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/75/endpoints
module "clue-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.clue.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0ce468f29514248e6"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/4/endpoints
module "connections-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.connections.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07d8c2533f6d96894"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/368/endpoints
module "graffiti-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.graffiti.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d7ec9b43f58fd715"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/3/endpoints
module "users-service-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "dev.users-service.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-05dd975d62ccc04fe"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/86/endpoints
module "passport-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.passport.twitch.a2z.com."
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-05412989bd2e5679b"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/455/endpoints
module "sessions-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "dev.sessions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-08499c95f5b1efbcb"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/11/endpoints
module "owl-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.owl-dev.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-02a7897a39672d1a5"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/324/endpoints
module "aegis-gateway-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "gateway.service.safety-staging.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0156870b4e359ba23"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/127/endpoints
module "guardian-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.guardian.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0c461f733496c5913"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/302/endpoints
module "history-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.beta.twitchhistoryservice.s.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-048392a4b1b0d3fcf"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/380/endpoints
module "ipblock-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "ipblock.service.safety-staging.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0156870b4e359ba23"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/22/endpoints
module "ldap-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "ldap.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0437151f68c61b808"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/103/endpoints
module "mako-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.mako.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-05d84536a295ea789"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/351/endpoints
module "mulan-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "beta.mulan.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0a8e72c4b8f792c52"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/182/endpoints
module "payday-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.payday.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d82c3aa83d29bcc4"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/448/endpoints
module "rbac-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.devsite-rbac.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0a6251c4f6b3b0bf0"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/297/endpoints
module "roster-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.roster.cb.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-07312f19a8e971f87"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/159/endpoints
module "spade-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "spade.internal.di.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-080f691601ce37dfb"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/314/endpoints
module "subscriptions-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.subscriptions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-028c4edba1d80b104"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/379/endpoints
module "valhalla-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "main.us-west-2.beta.valhalla.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-02a3ec55d88851404"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/388/endpoints
module "vodapi-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.vodapi.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-05b8c3b3eaaeaa9dc"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/192/endpoints
module "zuma-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.zuma.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0710d7a17dc0bb29a"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/167/endpoints
module "channel-properties-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.channel-properties.video.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-003d65355416376a0"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/173/endpoints
module "discovery-categorydb-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.oldcategorydb.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-02972ec3644c35afa"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/42/endpoints
module "drops-registry-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.registry.vhs.extensions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03f0934c4e024ed30"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/386/endpoints
module "everdeen-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "beta.everdeen.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-05fd4d8d40ca27ab4"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/95/endpoints
module "following-service-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.following-service.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0346730f17e35f70c"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/144/endpoints
# https://jira.twitch.com/browse/PROMO-739
module "hypeman-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "dev.hypeman.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03d1a58e4d84fb8fe"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/356/endpoints
module "dmca-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "apiserver-dmca.service.safety-staging.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0156870b4e359ba23"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/352/endpoints
module "ripley-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}", "${aws_security_group.nossl-vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "beta.ripley.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0302ab0bc9133e1a4"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/67/endpoints
module "saul-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "us-west-2.beta.saul.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-029ff6ef947aa9cb4"
  vpc_id            = "${local.vpc_id}"
}

## https://catalog.xarth.tv/services/96/endpoints
# module "payments-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"
#
#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "beta.payments-service.twitch.a2z.com"
#   service_name      = "VPC PEERING"
#   vpc_id            = "${local.vpc_id}"
# }

## https://catalog.xarth.tv/services/47/endpoints
# module "moneypenny-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"
#
#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "beta.moneypenny.twitch.a2z.com"
#   service_name      = "VPC PEERING"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/7/endpoints
module "sso-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.nossl-vpc-endpoints.id}"]          # it's actually https though
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "dev1.sso-dev.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-06f60f5347bb713fa"
  vpc_id            = "${local.vpc_id}"
}

## https://catalog.xarth.tv/services/542/endpoints
# module "revenue-config-vpc-endpoint" {
#   source = "../modules/vpc-endpoint"
#
#   security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
#   subnet_ids        = ["${local.subnet_ids}"]
#   service_dns_entry = "staging.ad-revenue-config.twitch.a2z.com"
#   service_name      = "VPC PEERING"
#   vpc_id            = "${local.vpc_id}"
# }

# https://catalog.xarth.tv/services/???/endpoints 
# SSL: true 
# PORT: 443 
module "boxart-extensions-staging-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "staging.boxart.extensions.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0c7dabf1539104158"
  vpc_id            = "${local.vpc_id}"
}

# https://catalog.xarth.tv/services/143/endpoints
# SSL: true
# PORT: 443
module "jenkins-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${local.subnet_ids}"]
  service_dns_entry = "jenkins-og.xarth.tv"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-03ea5cd3a1472a50f"
  vpc_id            = "${local.vpc_id}"
}

# CHaOS Sentry instance
module "sentry-chaos-prod-vpc-endpoint" {
  source = "../modules/vpc-endpoint"

  security_groups   = ["${aws_security_group.vpc-endpoints.id}"]
  subnet_ids        = ["${split(",", replace(join(",", local.subnet_ids),"subnet-095a737b8c52df148,",""))}"] # sentry is not in us-west-2c
  service_dns_entry = "sentry.chaos.twitch.a2z.com"
  service_name      = "com.amazonaws.vpce.us-west-2.vpce-svc-0d5a7353af460713c"
  vpc_id            = "${local.vpc_id}"
}
