# IAM_ACCESS_KEY_ROTATED
## What does this do?
<img src="aggregation_example.png">
<img src="IAM_ACCESS_KEY_ROTATED.png">
This cloud formation creates a stack for tracking compliance for IAM access key age. It does using a modified custom AWS Config Rule taken from https://aws.amazon.com/blogs/security/announcing-the-aws-config-rules-repository-a-new-community-based-source-of-custom-rules-for-aws-config/ and https://github.com/awslabs/aws-config-rules/tree/master/python/IAM_ACCESS_KEY_ROTATED. It then sets up a custom Cloudwatch event rule and alarm which sends alerts to pagerduty when an access key is out of date. It also creates aggregators for a central aggregating account. This stack is meant to be deployed using a stack set from a central compliance account. 

## How should this be used
In the model of one aws account per service per environnment, we recommend setting up a central compliance account per environment for the team. This central account will contain the lambda, aggregation, and stack set for managing the stacks in the service (called target) accounts for that environment.

## Before you start
Because AWS is AWS, they have a lot of hidden gotchas that can cause issues. For starters, AWS Config only allows exactly *one* ConfigurationRecorder and DeliveryChannel per region. On top of this, there's no option to view these in the AWS console. You must either delete these existing resources using the CLI (if you have them) or refactor the the cloud formation to take in a parameter for the ARN of your existing resources. 

## Setup
You must run the CF for the managed accounts before the compliance accounts.
### Stack-sets setup
Run the CF included in [administrator CF](../../accounts/administrator/AWSCloudFormationStackSetAdministrationRole.yml) in the compliance account.

Then run CF included in [target_accounts CF](../../accounts/target_accounts/AWSCloudFormationStackSetExecutionRole.yml) in each managed account. If you manage IAM credentials in the compliance account, also make sure to run this CF in that account as well.

### Compliance account setup
In the compliance account, use the RDK (https://github.com/awslabs/aws-config-rdk) to generate CF required and deploy the lambda to the compliance account. This deploys the lambda and CF required to manage the lambda to ONLY the account as defined by your current AWS creds.
Run `rdk init`
Then run `rdk deploy -f IAM_ACCESS_KEY_ROTATED`. 

Before creating the stack set, you will need:
- LambdaAccountID (this is the account ID for the compliance account)
- Pagerduty Integration URL (this should look something like https://events.pagerduty.com/integration/123456789/enqueue). 
- Account IDs of all Target Accounts (these MUST have already run the target account CF above). Include the compliance account ID if you also maintain IAM credentials in that account.

Then, create a stack set using `IAM_ACCESS_KEY_ROTATED.yaml` using the above parameters. 

#### Optional Aggregation View
While not included in the CF, because the CF creates aggregators for each target account, the compliance account can easily set up an aggregated view. To do this, go to AWS Config and add a new Aggregator. Make sure to select `
Allow AWS Config to replicate data from source account(s) into an aggregator account. You must select this checkbox to continue to add an aggregator.` Use `IAM_ACCESS_KEY_ROTATED` as the aggregator name, and then add all target accounts from above. If done correctly, you'll be able to see the aggregated view above. 

## Development Notes
We generated `IAM_ACCESS_KEY_ROTATED.yaml` by using the RDK by running `rdk create-rule-template -o remote-rule-template.json --all`. We've taken that and modified it to add additional cloudwatch rules, alarms, sns, aggregators, etc. We then used the cloud formation designer to convert it into yaml.
