resource "aws_iam_role" "twitch_inventory" {
  name                 = "twitch-inventory"
  max_session_duration = 43200

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::578510050023:role/twitch-inventory-master"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

# policy to allow access to support api
resource "aws_iam_policy" "twitch_inventory_cost_explorer" {
  name        = "twitch-inventory-cost-explorer"
  description = "Inventory access to cost explorer data"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "ce:*",
      "Resource": "*"
    }
  ]
}
EOF
}

# Attach permissions to iam_role
resource "aws_iam_role_policy_attachment" "twitch_inventory" {
  role       = "${aws_iam_role.twitch_inventory.name}"
  policy_arn = "${var.aws_read_only_access_arn}"
}

resource "aws_iam_role_policy_attachment" "twitch_inventory_support" {
  role       = "${aws_iam_role.twitch_inventory.name}"
  policy_arn = "${var.aws_support_access_arn}"
}

resource "aws_iam_role_policy_attachment" "twitch_inventory_cost_explorer" {
  role       = "${aws_iam_role.twitch_inventory.name}"
  policy_arn = "${aws_iam_policy.twitch_inventory_cost_explorer.arn}"
}
