resource "aws_iam_user" "jenkins" {
  name = "jenkins"
}

resource "sandstorm_aws_iam_access_key" "my-iam-user" {
  user                                = "${aws_iam_user.jenkins.name}"
  aws_access_key_id_sandstorm_key     = "admin-platform/team/jenkins/aws_access_key_id"
  aws_secret_access_key_sandstorm_key = "admin-platform/team/jenkins/aws_secret_access_key"
  isengard_account                    = "${local.account_id}"
  isengard_role                       = "Admin"
}

resource "aws_iam_user_policy" "jenkins" {
  user   = "${aws_iam_user.jenkins.id}"
  policy = "${data.aws_iam_policy_document.jenkins-p.json}"
}

data "aws_iam_policy_document" "jenkins-p" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "arn:aws:iam::289423984879:role/malachai/*",
      "arn:aws:iam::180116294062:role/malachai/*",
      "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/admin-panel-staging-integration-testing",
      "arn:aws:iam::005087123760:role/history-service-deploy-*",
      "arn:aws:iam::005087123760:role/history-service-staging",
      "arn:aws:iam::958416494912:role/history-service-deploy-*",
      "arn:aws:iam::005087123760:role/history-service-v3-staging",
      "arn:aws:iam::005087123760:role/history-*-v3-staging-deploy",
      "arn:aws:iam::958416494912:role/history-*-v3-prod-deploy",
    ]
  }
}
