terraform {
  backend "s3" {
    bucket  = "twitch-admin-platform-dev"
    key     = "tfstate/admin-services/terraform/accounts/twitch-admin-platform-dev"
    region  = "us-west-2"
    profile = "twitch-admin-platform-dev"
  }
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-admin-platform-dev"
}

// See https://git-aws.internal.justin.tv/sse/terraform-provider-sandstorm
provider "sandstorm" {}

data "aws_caller_identity" "current" {}

locals {
  account_id = "${data.aws_caller_identity.current.account_id}"
}
