package iprange

import (
	"fmt"
	"net"
)

// DNS based entries
type DNS struct {
	ips  []net.IP
	host string
}

// Contains returns if the ip is in this range
func (dns DNS) Contains(ip net.IP) bool {
	for _, dnsIP := range dns.ips {
		if dnsIP.Equal(ip) {
			return true
		}
	}
	return false
}

// Description return a description of the ip net
func (dns DNS) Description() string {
	return fmt.Sprintf("host<%s>", dns.host)
}

func newDNS(host string) (IPRange, error) {
	addrs, err := net.LookupHost(host)
	if err != nil {
		return nil, err
	}

	var ips []net.IP
	for _, addr := range addrs {
		ips = append(ips, net.ParseIP(addr))
	}

	return DNS{
		ips:  ips,
		host: host,
	}, nil
}

// GetDNSIPRanges returns IP ranges that are in a source file.
func GetDNSIPRanges() ([]IPRange, error) {
	var ipRanges []IPRange
	for _, host := range []string{} {
		ipRange, err := newDNS(host)
		if err != nil {
			return nil, err
		}
		ipRanges = append(ipRanges, ipRange)
	}
	return ipRanges, nil
}
