package iprange

import (
	"net"
)

// Duo represents a Duo iprange
type Duo struct {
	ipNet *net.IPNet
}

// Contains returns if the ip is in this range
func (duo Duo) Contains(ip net.IP) bool {
	return duo.ipNet.Contains(ip)
}

// Description return a description of the ip net
func (duo Duo) Description() string {
	return "duo"
}

// GetDuoIPRanges returns all AWS ip ranges
// See https://help.duo.com/s/article/1337?language=en_US
func GetDuoIPRanges() ([]IPRange, error) {
	var ranges []IPRange
	for _, block := range []string{
		"54.241.191.128/26",
		"54.236.251.192/26",
		"52.19.127.192/26",
		"52.32.63.128/26",
		"52.59.243.192/26",
		"35.182.14.128/26",

		// trusted
		"13.56.32.240/29",
		"52.32.63.176/30",
		"52.19.127.200/30",
		"52.59.243.200/30",
		"35.182.14.128/30",
	} {
		_, ipNet, err := net.ParseCIDR(block)
		if err != nil {
			return nil, err
		}
		ranges = append(ranges, Duo{ipNet: ipNet})
	}
	return ranges, nil
}
