package iprange

import (
	"net"
)

// Rollbar represents a rollbar IP range
type Rollbar struct {
	ipAddress   net.IP
	description string
}

// Contains returns if the ip is in this range
func (rollbar Rollbar) Contains(ip net.IP) bool {
	return rollbar.ipAddress.Equal(ip)
}

// Description return a description of the ip net
func (rollbar Rollbar) Description() string {
	return rollbar.description
}

// GetRollbarIPRanges returns the rollbar ip ranges
func GetRollbarIPRanges() []IPRange {
	return []IPRange{
		Rollbar{
			ipAddress:   net.ParseIP("35.201.81.77"),
			description: "Rollbar API Server",
		},
	}
}
