package iprange

import (
	"fmt"
	"net"
)

// Twitch represents a Twitch iprange
type Twitch struct {
	ipNet *net.IPNet
	name  string
}

// Contains returns if the ip is in this range
func (twitch Twitch) Contains(ip net.IP) bool {
	return twitch.ipNet.Contains(ip)
}

// Description return a description of the ip net
func (twitch Twitch) Description() string {
	return fmt.Sprintf("Twitch<%s>", twitch.name)
}

// GetTwitchIPRanges returns all AWS ip ranges
func GetTwitchIPRanges() ([]IPRange, error) {
	var ranges []IPRange
	for _, block := range []struct {
		ipNet string
		name  string
	}{
		{ipNet: "10.203.64.0/22", name: "twitch-admin-panel-aws"},
		{ipNet: "10.0.0.0/8", name: "twitch-subnets"},
		{ipNet: "52.223.240.0/20", name: "twitch-history-aws-internal"},
	} {
		_, ipNet, err := net.ParseCIDR(block.ipNet)
		if err != nil {
			return nil, err
		}
		ranges = append(ranges, Twitch{
			ipNet: ipNet,
			name:  block.name,
		})
	}
	return ranges, nil
}
