package main

import (
	"context"
	"flag"
	"os"

	"code.justin.tv/admin-services/terraform/cmd"
	"github.com/google/subcommands"
	"github.com/sirupsen/logrus"
)

func main() {
	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")

	logger := logrus.New()
	subcommands.Register(&cmd.ValidateEgress{
		Logger: logger,
	}, "")

	flag.Parse()
	os.Exit(int(subcommands.Execute(context.Background())))
}
