variable "vpc_id" {}

locals {
  prefix = "twitch-vpc-flow-logs"
}

resource "aws_flow_log" "flow" {
  iam_role_arn         = "${aws_iam_role.flow.arn}"
  log_destination_type = "cloud-watch-logs"
  log_destination      = "${aws_cloudwatch_log_group.flow.arn}"
  traffic_type         = "ACCEPT"
  vpc_id               = "${var.vpc_id}"
}

resource "aws_cloudwatch_log_group" "flow" {
  name = "${local.prefix}"
}

resource "aws_iam_role" "flow" {
  name               = "${local.prefix}"
  assume_role_policy = "${data.aws_iam_policy_document.flow-arp.json}"
}

data "aws_iam_policy_document" "flow-arp" {
  statement {
    principals {
      type        = "Service"
      identifiers = ["vpc-flow-logs.amazonaws.com"]
    }

    actions = ["sts:AssumeRole"]
  }
}

resource "aws_iam_role_policy" "flow" {
  name   = "${local.prefix}"
  role   = "${aws_iam_role.flow.id}"
  policy = "${data.aws_iam_policy_document.flow-rp.json}"
}

data "aws_iam_policy_document" "flow-rp" {
  statement {
    actions = [
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
      "logs:DescribeLogGroups",
      "logs:DescribeLogStreams",
    ]

    resources = [
      "*",
    ]
  }
}
